using System;
using System.Collections;
using System.Collections.Generic;
using UnityEngine;
using UnityEngine.UI;

[RequireComponent(typeof(AudioSource))]
public class ButtonsSFX : MonoBehaviour
{
    [SerializeField] Button[] Buttons;
    [SerializeField] AudioClip ClickSoundEffect;
    // Start is called before the first frame update
    private void OnEnable()
    {
        foreach (Button btn in Buttons)
        {
            btn.onClick.AddListener(PlaySoundEffect);
        }
    }
    private void OnDisable()
    {
        foreach (Button btn in Buttons)
        {
            btn.onClick.RemoveListener(PlaySoundEffect);
        }
    }

    private void PlaySoundEffect()
    {
        GetComponent<AudioSource>().PlayOneShot(ClickSoundEffect);
    }
}
